//
//  RootViewController.m
//  People
//
//  Created by Jonathan Diehl on 09.01.10.
//  Copyright RWTH 2010. All rights reserved.
//

#import "RootViewController.h"
#import "Person.h"


@implementation RootViewController

# pragma mark -
# pragma mark init & cleanup

// init
- (id)initWithPeople:(NSArray *)somePeople;
{
	self = [super init];
	if (self != nil) {
		people = [somePeople retain];
	}
	return self;
}

// cleanup
- (void) dealloc
{
	[people release];
	[super dealloc];
}

# pragma mark -
# pragma mark Table view methods

// number of sections
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 1;
}

// number of rows
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [people count];
}

// cell for indexpath
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:CellIdentifier] autorelease];
    }
    
	// Configure the cell.
	Person *person = [people objectAtIndex:indexPath.row];
	cell.textLabel.text = [NSString stringWithFormat:@"%@ %@", person.first_name, person.last_name];
	cell.detailTextLabel.text = person.email;

    return cell;
}

@end

